

export class ContractLinkPopup {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="javascript:void(0)" [onclick]="widget.close" class="fa fa-times-circle"></a>
			</div>

			<h1>Contracten koppelen</h1>
		</div>
		
		<input type="text" name="q_contract_link" placeholder="Zoek..." style="width: 100%;" />
		
		<div id="contract-link-results"></div>
	`;
	
	tplResult = `
		<table class="table tbl-contract-link">
			<thead>
				<tr>
					<th style="width: 80px;"></th>
					<th>Klantnaam</th>
					<th>Contract</th>
					<th>Waarde</th>
					<th>Contract type</th>
					<th>Startdatum</th>
					<th>Einddatum</th>
					<th>Verlengdatum</th>
					<th>Status</th>
				</tr>
			</thead>
			<tbody ez-for="contracts" ez-item="c">
				<tr contract-id="{{c.contractId}}" [onclick]="widget.toggleContract" class="pointer">
					<td>
						<input type="checkbox" class="check-contract" />
					</td>
					<td>
						{{c.customerName ?? ''}}
					</td>
					<td>
						{{c.name}}
					</td>
					<td>
						{{c.amountDescription}}
					</td>
					<td>
						{{c.contractTypeName}}
					</td>
					<td>
						{{ c.startDate ? format_date(c.startDate, {dmy: true}) : '' }}
					</td>
					<td>
						{{ c.endDate ? format_date(c.endDate, {dmy: true}) : '' }}
					</td>
					<td>
						{{ c.renewalDate ? format_date(c.renewalDate, {dmy: true}) : '' }}
					</td>
					<td>
						{{_('contract_status.'+c.status)}}
					</td>
				</tr>
			</tbody>
			<tbody ez-if="contracts.length == 0">
				<tr>
					<td colspan="9" class="no-results">
						Geen resultaten
					</td>
				</tr>
			</tbody>
	
		</table>
	`;
	
	container = null;
	
	contracts = [];
	linkedContractIds = [];
	contractId = null;
	
	callback_close = null;
	
	closePopupCallback() {
		if ( this.callback_close ) {
			this.callback_close();
		}
	};
	
	constructor(contractId) {
		this.contractId = contractId;
		this.loadContracts( contractId );
	}
	
	
	init(e) {
		this.container = e;
		
		this.render();
	}
	
	setContractId( id ) { this.task.contractId = id; }
	
	setCallbackClose( c ) {
		this.callback_close = c;
	}
	
	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.setObject('widget', this);
		this.ezTpl.render();
		
		this.renderResults();
		
		document.querySelector('input[name=q_contract_link]').focus();
		document.querySelector('input[name=q_contract_link]').addEventListener('change', (evt) => {
			this.loadContracts();
		});
		
	}
	
	renderResults() {
		let ezTplResults = new EzTemplate( '#contract-link-results' );
		ezTplResults.loadHtml( this.tplResult );
		ezTplResults.setVar('contracts', this.contracts);
		ezTplResults.setObject('widget', this);
		ezTplResults.render();
		
		
		$('.tbl-contract-link tr[contract-id]').each(function(index, node) {
			let cid = parseInt( $(node).attr('contract-id') );
			
			// TODO: check/uncheck..
			console.log(this.linkedContractIds.indexOf(cid));
			if (this.linkedContractIds.indexOf(cid) != -1) {
				$(node).find('.check-contract').prop('checked', true);
			}
			
		}.bind(this));
		
		$('.tbl-contract-link .check-contract').on('change', function(evt, p) {
			let cid = $(evt.currentTarget).closest('tr').attr('contract-id');
			
			if ( $(evt.currentTarget).prop('checked') )
				this.linkContract( cid );
			else
				this.unlinkContract( cid );
		}.bind(this));
	}
	
	
	
	close() {
		close_popup();
	}
	
	show() {
		this.container = show_popup('Contracten Koppelen', '');
		
		this.container.get(0).close_callback = function() {
			if (this.callback_close) {
				this.closePopupCallback();
			}
		}.bind(this);
		
		this.render();
	}
	
	
	linkContract(refContractId) {
		postUrl( '/service/contracts/edit.do', {
			a: 'linkRelatedContract',
			refContractId: refContractId,
			contractId: this.contractId
		});
		
		showToastMessage( 'Contract gekoppeld' );
	}
	
	unlinkContract(refContractId) {
		postUrl( '/service/contracts/edit.do', {
			a: 'unlinkRelatedContract',
			refContractId: refContractId,
			contractId: this.contractId
		});
		
		showToastMessage( 'Contract ontkoppeld' );
	}
	
	toggleContract(e) {
		
		if ( $(e.target).hasClass('check-contract') )
			return;
		
		let c = $(e.target).closest('tr');
		let o = c.find('input.check-contract');
		
		if (o.length == 0)
			return;
		
		o.prop('checked', !o.prop('checked'));
		o.change();
	}
	
	loadContracts( currentContractId ) {
		
		let q = '';
		
		let inp_q = document.querySelector('input[name=q_contract_link]');
		if (inp_q) {
			q = $.trim( inp_q.value );
		}
		
		postUrl( '/service/contracts/list.do', {
			excludeContractId: this.contractId,
			q: q
		}).then( async (e) => {
			let json = await e.json();
			if (json.error) {
				return showErrorWidget(json);
			}
			
			this.contracts = json.contracts;
			this.linkedContractIds = json.linkedContractIds;
			this.renderResults();
			
			this.loading = false;
		});
	}
	
	
}


